<?php

namespace App\Api\V1\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SoapIntegrationController extends Controller
{
    public function sendSoapRequest(Request $request)
    {
        try {
            // Get the SOAP request data from the request
            $soapRequest = $request->input('soap_request');

            // Set the SOAP endpoint URL
            $url = $request->input('url');

            // Create a SOAP client
            $client = new \SoapClient(null, [
                'location' => $url,
                'uri' => $url,
            ]);

            // Send the SOAP request and get the response
            $response = $client->__doRequest($soapRequest, $url, 'YourSOAPAction', SOAP_1_2);

            // Display the response
            return response($response, 200)->header('Content-Type', 'text/xml');
        } catch (\Exception $ex) {
            return response()->json(['error' => 'An error occurred: ' . $ex->getMessage()], 500);
        }
    }
  
    public function sendSoapRequest_getPPKB(Request $request)
    {
        try {
            // Get the SOAP request data from the request
            $soapRequest = $request->input('soap_request');

            // Set the SOAP endpoint URL
            $url = $request->input('url');

            // Create a SOAP client
            $client = new \SoapClient(null, [
                'location' => $url,
                'uri' => $url,
            ]);

            // Send the SOAP request and get the response
            $response = $client->__doRequest($soapRequest, $url, 'YourSOAPAction', SOAP_1_2);

            // Display the response
            return response($response, 200)->header('Content-Type', 'text/xml');
        } catch (\Exception $ex) {
            return response()->json(['error' => 'An error occurred: ' . $ex->getMessage()], 500);
        }
    }


    public function sendSoapRequest_getEntryPKK(Request $request)
    {
        try {
            // Get the SOAP request data from the request
            $soapRequest = $request->input('soap_request');

            // Set the SOAP endpoint URL
            $url = $request->input('url');

            // Create a SOAP client
            $client = new \SoapClient(null, [
                'location' => $url,
                'uri' => $url,
            ]);

            // Send the SOAP request and get the response
            $response = $client->__doRequest($soapRequest, $url, 'YourSOAPAction', SOAP_1_2);

            // Display the response
            return response($response, 200)->header('Content-Type', 'text/xml');
        } catch (\Exception $ex) {
            return response()->json(['error' => 'An error occurred: ' . $ex->getMessage()], 500);
        }
    }

    
    public function sendSoapRequest_getEntryRKBM(Request $request)
    {
        try {
            // Get the SOAP request data from the request
            $soapRequest = $request->input('soap_request');

            // Set the SOAP endpoint URL
            $url = $request->input('url');

            // Create a SOAP client
            $client = new \SoapClient(null, [
                'location' => $url,
                'uri' => $url,
            ]);

            // Send the SOAP request and get the response
            $response = $client->__doRequest($soapRequest, $url, 'YourSOAPAction', SOAP_1_2);

            // Display the response
            return response($response, 200)->header('Content-Type', 'text/xml');
        } catch (\Exception $ex) {
            return response()->json(['error' => 'An error occurred: ' . $ex->getMessage()], 500);
        }
    }

    
    public function sendSoapRequest_getEntrySPB(Request $request)
    {
        try {
            // Get the SOAP request data from the request
            $soapRequest = $request->input('soap_request');

            // Set the SOAP endpoint URL
            $url = $request->input('url');

            // Create a SOAP client
            $client = new \SoapClient(null, [
                'location' => $url,
                'uri' => $url,
            ]);

            // Send the SOAP request and get the response
            $response = $client->__doRequest($soapRequest, $url, 'YourSOAPAction', SOAP_1_2);

            // Display the response
            return response($response, 200)->header('Content-Type', 'text/xml');
        } catch (\Exception $ex) {
            return response()->json(['error' => 'An error occurred: ' . $ex->getMessage()], 500);
        }
    }

    


}