<?php

namespace App;

use Hash;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use Notifiable;

    protected $table = 'TMUSER';
    public $primaryKey = 'UserId';
    public $incrementing = false;
    protected $keyType = 'string';
    protected $rememberTokenName = false;
    public $timestamps = false;
    protected $connection = 'sqlsrv2';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        // 'UserId',
        // 'UserAlias',
        // 'UserName',
        // 'UserPwd',

        'UserId',
        'UserName',
        'UserType',
        'Email',
        'Handphone',
        'MMcode'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    //diremark karena login/register custom
    // protected $hidden = [
    //     'UserPwd'
    // ];

    /**
     * Automatically creates hash for the user password.
     *
     * @param  string  $value
     * @return void
     */
    //diremark karena login/register custom
    // public function setPasswordAttribute($value)
    // {
    //     $this->attributes['UserPwd'] = ERV_Encrypt($value);
    // }

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
}
