<?php
if (! function_exists('ERV_Encrypt')) {
    function ERV_Encrypt($strText, $length = 0){
        $strResult = "";
        $intLenText = strlen(trim($strText));

        if($intLenText == 0) return "";

        for ($i=0; $i < $intLenText; $i++) { 
            $intAscii = ord(substr($strText, $i, 1)) + 128 - $intLenText;
            $strResult .= chr($intAscii);
        }
        return convert_from_latin1_to_utf8_recursively($strResult);
    }
}


if (! function_exists('convert_from_latin1_to_utf8_recursively')) {
    function convert_from_latin1_to_utf8_recursively($dat)
    {
        if (is_string($dat)) {
            return utf8_encode($dat);
        } elseif (is_array($dat)) {
            $ret = [];
            foreach ($dat as $i => $d) $ret[ $i ] = convert_from_latin1_to_utf8_recursively($d);

            return $ret;
        } elseif (is_object($dat)) {
            foreach ($dat as $i => $d) $dat->$i = convert_from_latin1_to_utf8_recursively($d);
            
            return $dat;
        } else {
            return $dat;
        }
    }
}

if (! function_exists('kirimSMS')) {
    function kirimSMS($no_telpon, $code){
        $message = "Kode Verifikasi ESS: ".$code;
        $url = "https://reguler.zenziva.net/apps/smsapi.php";
        $statusZenziva = '';
        $curlHandle = curl_init();
        curl_setopt($curlHandle, CURLOPT_URL, $url);
        curl_setopt($curlHandle, CURLOPT_POSTFIELDS, 'userkey='.config('zenziva.userkey').'&passkey='.config('zenziva.passkey').'&nohp='.$no_telpon.'&pesan='.urlencode($message));
        curl_setopt($curlHandle, CURLOPT_HEADER, 0);
        curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curlHandle, CURLOPT_TIMEOUT,30);
        curl_setopt($curlHandle, CURLOPT_POST, 1);
        $results = curl_exec($curlHandle);
        curl_close($curlHandle);

        $XMLdata = new \SimpleXMLElement($results);
        $statusZenziva = $XMLdata->message[0]->text;
        // dd((string)$result->getBody());
        return [
            'ok' => true, 
            // 'url' => $url,
            'resultSMS' => $statusZenziva
        ];
    }
}