<?php

namespace App\Api\V1\Controllers;

use App\Http\Controllers\Controller; 
use App\Api\V1\Requests\ChangePasswordRequest;
use Illuminate\Http\Request;
use Mail;

date_default_timezone_set('Asia/Jakarta');

class ChangePasswordController extends Controller
{

    public function index(ChangePasswordRequest $request){
       $empcode = $request->empcode;
       $email = $request->email;
       $newpassword = $request->newpassword;
       //check email ke db atau sp
//       $user = User::where('email', $email)->first();
//       if ($user){
//            //jika user ditemukan
//            //kirim email
//           $this->sendEmail();
//           return response("Berhasil", 200);
//       }else{
//            //jika user tidak ditemukan
//           return response($email." tidak terdaftar", 403);
//       }

        //kirim email dengan parameter password yang sudah di ambil dari db/sp

        //$email = "emi_sastra@yahoo.com"; 

        $encrypt = bcrypt($newpassword); // ini default           
      
        $response =   $this->updatePassword($empcode, $newpassword);
       
        $response =   $this->sendEmail($email, $newpassword);

        return $response;
    } 
    

    public function sendEmail($email, $pwd){
        try {
            Mail::send('emails.sample-email', ["content" =>  $pwd ], function($message) use ($email) {
                $message->to($email, $email)
                    ->subject('Forgot Password')
                    ->from('bachmansabar@gmail.com','ERV Software');
            });

            return response()->json([
                'code' =>  'ok',
                'message' => "Password sudah dikirim ke email anda. Silahkan buka email anda. Terima kasih"
            ]);

        } catch(Exception $e) {
            return response()->json([
                'code' => $e->getStatusCode(),
                'message' => $e->getMessage()
            ]);
        }
    }

    public function updatePassword($empcode, $pwd)
    {
        $encrypt = ERV_Encrypt($pwd);
        
        $data = \DB::connection('sqlsrv2')->statement('exec [ERV_SP_Update_Data_Password] ?, ?', [$empcode, $encrypt]);

        //dd($data);

        return response()
            ->json([
                'status' => 'ok',
                'empcode' => $empcode,
                '$pwd' => $pwd,
                'message' => 'success'
            ]);
    }

}